!!ARBvp1.0
# bump decal__nodefines.vsh

TEMP r0, r1, r5, r6;

PARAM c[9] = {program.env[0..8]};
PARAM c0 = {0.3, 0.5, 2.0, 0.0};
PARAM c21 = {0.0, 1.0, -1.0, 0.0};

ATTRIB v0 = vertex.position;
ATTRIB v1 = vertex.normal;
ATTRIB v2 = vertex.attrib[6];	# Tangent
ATTRIB v3 = vertex.texcoord[0];
ATTRIB v4 = vertex.color.primary;

ALIAS oPos = result.position;
ALIAS oD0 = result.color.primary;
ALIAS oD1 = result.color.secondary;
ALIAS oT0 = result.texcoord[0];

# transform position
DP4 oPos.x, v0, c[0];
DP4 oPos.y, v0, c[1];
DP4 oPos.z, v0, c[2];
DP4 oPos.w, v0, c[3];

# send vertex color
MOV oD0, v4;

# Use decal coordinates (for bump also)
MOV oT0, v3;

# cross prod to generate binormal in model space -- "w"
MOV r1, v2;
MUL r0, v1.zxyw, r1.yzxw;
MAD r5, v1.yzxw, r1.zxyw, -r0;

# transform the light vector by the resulting matrix to get the light dir in tan space (into r6)
DP3 r6.x, -r5, c[8];
DP3 r6.y, r1, c[8];
DP3 r6.z, v1, c[8];
MOV r6.w, c21.w;

# multiply by a half then add half (to be scaled biased back inside pixel shader)
MAD oD1.xyz, r6, c0.y, c0.y;

END
